/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.harvest;

import io.github.fabricators_of_create.porting_lib.entity.events.PlayerEvents;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1836;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;

public class MaintainedModifier
extends Modifier
implements ConditionalStatModifierHook {
    private static final class_2561 MINING_SPEED = TConstruct.makeTranslation("modifier", "maintained.mining_speed");
    private static final class_2561 VELOCITY = TConstruct.makeTranslation("modifier", "maintained.velocity");
    private static final float MINING_AT_FULL = 6.0f;
    private static final float MIN_BOOST_PERCENT = 0.5f;
    private static final float VELOCITY_AT_FULL = 0.05f;

    private static float getTotalBoost(IToolStackView tool, int level) {
        int max;
        float min;
        int durability = tool.getCurrentDurability();
        if ((float)durability > (min = (float)(max = tool.getStats().getInt(ToolStats.DURABILITY)) * 0.5f)) {
            return (float)level * ((float)durability - min) / ((float)max - min);
        }
        return 0.0f;
    }

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, TinkerHooks.CONDITIONAL_STAT);
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable class_1657 player, List<class_2561> tooltip, TooltipKey tooltipKey, class_1836 tooltipFlag) {
        boolean harvest = tool.hasTag(TinkerTags.Items.HARVEST);
        if (harvest || tool.hasTag(TinkerTags.Items.RANGED)) {
            double boost = level;
            if (tooltipKey == TooltipKey.SHIFT) {
                boost = MaintainedModifier.getTotalBoost(tool, level);
            }
            if (boost > (double)0.01f) {
                if (harvest) {
                    this.addFlatBoost(MINING_SPEED, boost * 6.0 * (double)tool.getMultiplier(ToolStats.MINING_SPEED), tooltip);
                } else {
                    this.addFlatBoost(VELOCITY, boost * (double)0.05f * (double)tool.getMultiplier(ToolStats.VELOCITY), tooltip);
                }
            }
        }
    }

    @Override
    public void onBreakSpeed(IToolStackView tool, int level, PlayerEvents.BreakSpeed event, class_2350 sideHit, boolean isEffective, float miningSpeedModifier) {
        if (isEffective) {
            event.setNewSpeed(event.getNewSpeed() + 6.0f * MaintainedModifier.getTotalBoost(tool, level) * miningSpeedModifier * tool.getMultiplier(ToolStats.MINING_SPEED));
        }
    }

    @Override
    public float modifyStat(IToolStackView tool, ModifierEntry modifier, class_1309 living, FloatToolStat stat, float baseValue, float multiplier) {
        if (stat == ToolStats.VELOCITY) {
            baseValue += 0.05f * MaintainedModifier.getTotalBoost(tool, modifier.getLevel()) * multiplier;
        }
        return baseValue;
    }
}

